<?php
	if(isset($_GET['update_action'])) {
		$epath = "../";
        $db = json_decode(file_get_contents("../../data/main.db"), true);
        
		if($_GET['update_action'] == 'check') {
			sleep(2);

			$currentVersion = $db['Version'];

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://api.altusia.com/web-studio/latest-version?php");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
			$data = curl_exec($ch);
			
			$updates = json_decode($data, true);
			if($updates === null) {
				exit("Failed to connect to update checking API.");
			}
			
			if($updates['Success'] == true) {
				$v = $updates['Version'];

				$currentVersion = str_replace(".", "", $currentVersion);
				$v = str_replace(".", "", $v);

				if(intval($currentVersion) < intval($v)) {
					exit('download_info');
				}
				else {
					exit('
						<div style="text-align: center; padding: 17px 0 18px;">
							<div style="font-size: 55px; color: green;">
								<span class="glyphicon glyphicon-thumbs-up"></span>
							</div>
							There are no new updates available.
						</div>
					');
				}
			}
			else {
				exit("Received an invalid response from the Altusia Update API.");
			}
		}

		if($_GET['update_action'] == 'getinfo') {
			sleep(2);

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://api.altusia.com/web-studio/latest-version-details?php");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
			$data = curl_exec($ch);
			
			exit($data);
		}
	}
?>
	<div class="row">
		<div class="col-md-12">

			<div class="moduleBox">
				<div class="moduleBoxTitle">
					<strong>New Updates</strong>
				</div>
				<div class="moduleBoxBody">
					<div id="Status" style="text-align: center; padding: 30px 0;">
						<img src="http://i.altusia.com/13928797.gif">
						<br /><br />
						<span id="StatusText">Please Wait</span>
					</div>
					<div id="Result"></div>
				</div>
			</div>
			<div class="moduleBox">
				<div class="moduleBoxTitle">
					<strong>Current Version</strong>
				</div>
				<div class="moduleBoxBody">
					<p style="padding: 15px; margin:0px;">You are running version <?=$db['Version'];?></p>
				</div>
			</div>
		</div>
	</div>

	<script>
		$(document).ready(function() {
			$("#StatusText").html("Checking for updates...");

			$.get("docs/updates.php?update_action=check", function(data) {
				if(data == "download_info") {
					$("#StatusText").html("Downloading update information...");

					$.get("docs/updates.php?update_action=getinfo", function(data) {
						
						$("#Result").html( data );
						$("#Status").hide();
					});
				}
				else {
					$("#Result").html( data );
						$("#Status").hide();
				}
			});
		});

	</script>